﻿-----------------------------------------------------------------------------------
USE AdventureWorksOBP
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
RAD SA STRINGOVIMA (1)
Napisati funkciju koja prima string i vraæa novi string sastavljen od:
	druga polovica stringa + prva polovica stringa. 
Ako ulazni string ima neparan broj znakova, 
neka u prvoj polovici bude manji broj znakova 
(primjerice, za "Slon" treba vratiti "onSl", za "Mirko" treba "rkoMi").
*/
CREATE FUNCTION dbo.Obrni
(
	@s nvarchar(max)
)
RETURNS nvarchar(max)
AS
BEGIN
	DECLARE @d1 nvarchar(max)
	DECLARE @d2 nvarchar(max)
	DECLARE @duljina1 int
	DECLARE @duljina2 int

	SET @duljina1 = LEN(@s) / 2
	SET @duljina2 = LEN(@s) - @duljina1
	
	SET @d1 = SUBSTRING(@s, 1, @duljina1)
	SET @d2 = SUBSTRING(@s, @duljina1 + 1, @duljina2)

	RETURN @d2 + @d1
END
GO
-- Pozvati funkciju s nekim parametrom i ispisati rezultat.
PRINT dbo.Obrni('Slon')
PRINT dbo.Obrni('Mirko')
-- Ispisati obrnuti naziv svakog proizvoda iz tablice Proizvod.
SELECT dbo.Obrni(Naziv) FROM Proizvod
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
RAD SA STRINGOVIMA (2)
Napisati funkciju koja prima string i koja vraæa broj pojavljivanja slova 'a' u tom stringu.
*/
CREATE FUNCTION dbo.BrojSlovaA
(
	@s nvarchar(max)
)
RETURNS int
AS
BEGIN
	DECLARE @curr int
	DECLARE @next int
	DECLARE @broj int

	SET @curr = 1
	SET @next = 1
	SET @broj = 0
	WHILE @next > 0 BEGIN
		SET @next = CHARINDEX('a', @s, @curr)
		IF @next > 0
			SET @broj = @broj + 1

		SET @curr = @next + 1
	END
	RETURN @broj
END
GO
-- Pozvati funkciju s nekim parametrom i ispisati rezultat.
PRINT dbo.BrojSlovaA('Juro')
PRINT dbo.BrojSlovaA('Ana')
PRINT dbo.BrojSlovaA('Ankica')
PRINT dbo.BrojSlovaA('Anakonda')
-- Dohvatiti sve proizvode iz i pokraj svakog ispisati broj pojavljivanja slova 'a' u nazivu.
SELECT *, dbo.BrojSlovaA(Naziv) AS BrojSlovaA FROM Proizvod
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
RAD SA STRINGOVIMA (2)
Napisati funkciju koja prima string i koja vraæa broj samoglasnika u tom stringu.
*/
CREATE FUNCTION dbo.BrojSamoglasnika
(
	@s nvarchar(max)
)
RETURNS int
AS
BEGIN
	DECLARE @i int
	DECLARE @broj int
	DECLARE @znak char(1)

	SET @i = 1
	SET @broj = 0
	WHILE @i <= LEN(@s) BEGIN
		SET @znak = SUBSTRING(@s, @i, 1)
		IF @znak IN ('a', 'e', 'i', 'o', 'u')
			SET @broj = @broj + 1

		SET @i = @i + 1
	END
	RETURN @broj
END
GO
-- Pozvati funkciju s nekim parametrom i ispisati rezultat.
PRINT dbo.BrojSamoglasnika('Juro')
PRINT dbo.BrojSamoglasnika('Ana')
PRINT dbo.BrojSamoglasnika('Ankica')
PRINT dbo.BrojSamoglasnika('Anakonda')
-- Dohvatiti sve proizvode iz i pokraj svakog ispisati broj samoglasnika u nazivu.
SELECT *, dbo.BrojSamoglasnika(Naziv) AS BrojSamoglasnika FROM Proizvod
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
XML (1)
Napisati proceduru koja prima XML dokument oblika:
<Gradovi>
	<Grad>Karlovac</Grad>
	…
</Gradovi>
Neka procedura vrati tablicu s nazivima svih gradova.
*/
CREATE PROC IspisiNazive
	@gradovi xml
AS
SELECT
	Tablica.Stupac.value('.', 'nvarchar(50)') AS Grad
FROM @gradovi.nodes('/Gradovi/Grad') AS Tablica(Stupac)
GO
-- Pozvati proceduru  s nekim parametrom.
EXEC IspisiNazive '<Gradovi><Grad>Karlovac</Grad><Grad>Sisak</Grad><Grad>Kutina</Grad></Gradovi>'
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
XML (1)
Proširiti prethodni XML dokument tako da svaki grad sadržava atribut "PostanskiBroj". 
Promijeniti proceduru tako da uz naziv grada ispisuje i poštanski broj.
*/
ALTER PROC IspisiNazive
	@gradovi xml
AS
SELECT
	Tablica.Stupac.value('.', 'nvarchar(50)') AS Grad,
	Tablica.Stupac.value('@Pbr', 'nvarchar(5)') AS Pbr
FROM @gradovi.nodes('/Gradovi/Grad') AS Tablica(Stupac)
GO
-- Pozvati proceduru  s nekim parametrom.
EXEC IspisiNazive '<Gradovi><Grad Pbr="10000">Zagreb</Grad><Grad Pbr="31000">Osijek</Grad></Gradovi>'
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
XML (2)
Napisati proceduru koja prima XML dokument oblika:
<Kupci>
	<Kupac>
		<Ime>Mirko</Ime>
		<Prezime>Mirkiæ</Prezime>
		<Grad>Osijek</Grad>
	</Kupac>
	…
</Kupci>
Neka procedura vrati dva skupa redaka:
- Prezimena svih kupaca poslagana abecednim redom
- Nazive gradova. Ako ima više kupaca iz istog grada, grad treba ispisati samo jednom.
*/
CREATE PROC Zad6
	@dok xml
AS
SELECT
	Tablica.Stupac.value('.', 'nvarchar(50)') AS Prezime
FROM @dok.nodes('/Kupci/Kupac/Prezime') AS Tablica(Stupac)
ORDER BY Prezime

SELECT DISTINCT
	Tablica.Stupac.value('.', 'nvarchar(50)') AS Grad
FROM @dok.nodes('/Kupci/Kupac/Grad') AS Tablica(Stupac)
GO
-- Pozvati proceduru  s nekim parametrom. Provjera da li vraæa dva skupa redaka.
EXEC Zad6 '
	<Kupci>
		<Kupac>
			<Ime>Mirko</Ime>
			<Prezime>Mirkiæ</Prezime>
			<Grad>Osijek</Grad>
		</Kupac>
		<Kupac>
			<Ime>Ana</Ime>
			<Prezime>Aniæ</Prezime>
			<Grad>Osijek</Grad>
		</Kupac>
	</Kupci>'
GO
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Zadatak 7.
/*
XML (3)
Napisati proceduru koja prima XML dokument oblika:
<Osobe>
	<Osoba ID="1">Ana Aniæ</Osoba>
	<Osoba ID="2">Mira Miriæ</Osoba>
	…
</Osobe>
Neka procedura vrati imena i prezimena te ID-eve svih osoba. 
Svaki ID treba nadopuniti s nulama s lijeve strane na duljinu od 5 znakova 
(Primjerice, za ID = 1 treba ispisati “00001”, za ID = “176” treba ispisati “00176”)
*/
CREATE PROC Zad7
	@dok xml
AS
SELECT
	Tablica.Stupac.value('.', 'nvarchar(50)') AS ImePrezime,
	CASE  
		WHEN LEN(Tablica.Stupac.value('@ID', 'nvarchar(50)')) = 1 THEN '0000' + Tablica.Stupac.value('@ID', 'nvarchar(50)')
		WHEN LEN(Tablica.Stupac.value('@ID', 'nvarchar(50)')) = 2 THEN  '000' + Tablica.Stupac.value('@ID', 'nvarchar(50)')
		WHEN LEN(Tablica.Stupac.value('@ID', 'nvarchar(50)')) = 3 THEN   '00' + Tablica.Stupac.value('@ID', 'nvarchar(50)')
		WHEN LEN(Tablica.Stupac.value('@ID', 'nvarchar(50)')) = 4 THEN    '0' + Tablica.Stupac.value('@ID', 'nvarchar(50)')
		WHEN LEN(Tablica.Stupac.value('@ID', 'nvarchar(50)')) = 5 THEN          Tablica.Stupac.value('@ID', 'nvarchar(50)')
	END AS ID
FROM @dok.nodes('/Osobe/Osoba') AS Tablica(Stupac)
GO
-- Pozvati proceduru  s nekim parametrom. 
EXEC zad7
	'<Osobe>
		<Osoba ID="1">Ana Aniæ</Osoba>
		<Osoba ID="35">Maja Majiæ</Osoba>
		<Osoba ID="158">Tanja Tanjiæ</Osoba>
		<Osoba ID="85002">Vera Veriæ</Osoba>
	</Osobe>'
GO
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
